// GMSH script to generate the mesh for the hole plate example
// Documentation: https://gmsh.info/doc/texinfo/gmsh.html
// Author: Andrea Pavan
// Date: 22/12/2022


//parameters
l1 = 10.0;		//domain x size
l2 = 10.0;		//domain y size
l3 = 1.0;		//domain z size
a = 1.0;        //hole radius
surfaceMeshSize = 0.5;		//mesh size at the boundaries


//change geometry kernel
SetFactory("OpenCASCADE");


//-----------------------
//  geometry creation
//-----------------------

Point(1) = {a, 0, 0, surfaceMeshSize/5};
Point(2) = {l1, 0, 0, surfaceMeshSize};
Point(3) = {l1, l2, 0, surfaceMeshSize};
Point(4) = {0, l2, 0, surfaceMeshSize};
Point(5) = {0, a, 0, surfaceMeshSize/5};
Point(6) = {0, 0, 0, surfaceMeshSize/5};

Line(1) = {1, 2};
Line(2) = {2, 3};
Line(3) = {3, 4};
Line(4) = {4, 5};
Circle(5) = {5, 6, 1};

Curve Loop(1) = {1:5};
Plane Surface(1) = {1};
Extrude {0, 0, l3} {
  Curve{1}; Curve{2}; Curve{3}; Curve{4}; Curve{5}; 
}
Curve Loop(7) = {8, 10, 12, 14, 15};
Plane Surface(7) = {7};
Surface Loop(1) = {7, 2, 6, 5, 4, 3, 1};
Volume(1) = {1};
